/*
 * Diese Datei ist Teil des GDialog Projektes:
 * "Gigaset-Erweiterung fr ProjectX"
 * 
 * Das GDialog Projekt ist freigegeben unter
 * der GNU Public Licence (GPL), deren Text sich in
 * dem Quellen-Verzeichnis befindet. Ist er dort nicht
 * mehr vorhanden, so kann er unter http://www.gnu.org/licenses/gpl.html
 * eingesehen werden.
 */
package de.m740.projectx.gigaset;

import java.awt.BorderLayout;
import java.awt.Point;
import java.io.PrintWriter;
import java.io.StringWriter;

import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

/**
 * @author arnaud
 * 
 */
public class GConsole extends JPanel {

    private static final long serialVersionUID = 1L;

    private JTextArea aTextArea = null;

    private JScrollPane aScrollPane = null;

    private static GConsole aInstance = null;

    /**
     * 
     */
    private GConsole() {
        super();
        initialize();
    }

    private void initialize() {
        try {
            setInstance(this);
            setLayout(new BorderLayout());
            add(getScrollPane(), BorderLayout.CENTER);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private JScrollPane getScrollPane() {
        if (aScrollPane == null) {
            aScrollPane = new JScrollPane(getTextArea());
        }
        return aScrollPane;
    }

    private JTextArea getTextArea() {
        if (aTextArea == null) {
            aTextArea = new JTextArea();
        }
        return aTextArea;
    }

    public static void clear() {
        try {
            if (aInstance != null) {
                JTextArea tmpArea = aInstance.getTextArea();
                tmpArea.setText("");
                aInstance.getScrollPane().getViewport().setViewPosition(
                        new Point(0, tmpArea.getHeight()));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setMessage(String inpMsg) {
        try {
            if (aInstance == null) {
                System.out.println(inpMsg);
            } else {
                JTextArea tmpArea = aInstance.getTextArea();
                tmpArea.append(inpMsg);
                tmpArea.append("\n");
                aInstance.getScrollPane().getViewport().setViewPosition(
                        new Point(0, tmpArea.getHeight()));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setInfo(String inpMsg) {
        try {
            inpMsg = "Info> "+inpMsg;
            if (aInstance == null) {
                System.out.println(inpMsg);
            } else {
                JTextArea tmpArea = aInstance.getTextArea();
                tmpArea.append(inpMsg);
                tmpArea.append("\n");
                aInstance.getScrollPane().getViewport().setViewPosition(
                        new Point(0, tmpArea.getHeight()));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setErrorMessage(Throwable inpError) {
        try {
            StringWriter sw = new StringWriter();
            inpError.printStackTrace(new PrintWriter(sw));
            String tmpStr = sw.toString();
            setMessage(tmpStr);
            if (aInstance != null) {
                System.out.println(tmpStr);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static GConsole getInstance() {
        if (aInstance == null) {
            aInstance = new GConsole();
        }
        return aInstance;
    }

    private static void setInstance(GConsole inpInstance) {
        aInstance = inpInstance;
    }

}
